
vB_XHTML_Ready.subscribe(init_report_popupmenus);

function init_report_popupmenus(baseNode)
{
	if (!YAHOO.lang.isUndefined(YAHOO.vBulletin.vBPopupMenu))
	{
		var menus = YAHOO.util.Dom.getElementsByClassName("reportpopupmenu", "span", document.body);
		for (var i = 0; i < menus.length; i++)
		{
		    var links = YAHOO.util.Dom.getFirstChild(menus[i]);
			if (links.href)
			{
			    var index = links.href.indexOf("p=");
                if (index > 0)
                {
                    var postid = links.href.substr(index+2);
			        YAHOO.util.Dom.addClass(links, 'popupctrl'); 
			
			        var menuobj = new vB_ReportPopupMenu(menus[i], YAHOO.vBulletin.vBPopupMenu, postid);
			        YAHOO.vBulletin.vBPopupMenu.register_menuobj(menuobj);
			    }
			}
		}
		
		console.log('Report popup menu init success');
	}
	else
	{
		console.log('Popup menu init in wrong order -- report popup init');
	}
}


function vB_ReportPopupMenu(container, factory, postid)
{
	this.init(container, factory);
	this.postid = postid;
	this.ajaxreq = null;
}

vB_ReportPopupMenu.prototype = new PopupMenu();

// #############################################################################
// vB_Report_Handler
// #############################################################################

/**
* Submit OnReadyStateChange callback. Uses a closure to keep state.
* Remember to use me instead of "this" inside this function!
*/
vB_ReportPopupMenu.prototype.handle_submit = function(ajax)
{
	if (ajax.responseXML)
	{
		//this.close_menu();
		// check for error first
		var error = ajax.responseXML.getElementsByTagName('error');
		if (error.length)
		{
	        YAHOO.util.Dom.setStyle(this.menu.reportform, 'opacity', '1');
	        YAHOO.util.Dom.setStyle(this.menu.reportprogress, 'display', 'none');
			
			alert(error[0].firstChild.nodeValue);
		}
		else
		{
			var reportresult =  ajax.responseXML.getElementsByTagName('reportresult')[0].firstChild.nodeValue;
			//force a reload of the report menu on the next activation so that
			//the duplicate error will show.
			alert(reportresult);
			
			this.close_menu();
			this.menu.parentNode.removeChild(this.menu);
			this.menu = null;

		}
	}
}

/**
* Populate OnReadyStateChange callback. Uses a closure to keep state.
* Remember to use me instead of "this" inside this function!
*/
vB_ReportPopupMenu.prototype.handle_menu_load  = function(ajax)
{
	if (ajax.responseXML)
	{
		if (!this.menu)
		{
			// Create new div to hold report menu html
			this.menu = document.createElement('div');
			this.menu.id = this.divname;

			YAHOO.util.Dom.addClass(this.menu, "popupbody");
			YAHOO.util.Dom.addClass(this.menu, "popuphover");

			this.container.appendChild(this.menu);
			YAHOO.util.Event.on(this.menu, "keypress", this.repinput_onkeypress, this, true);
		}

		// check for error first
		var error = ajax.responseXML.getElementsByTagName('error');
		if (error.length)
		{
			this.menu.innerHTML = '<div class="blockbody"><div class="blockrow">' + error[0].firstChild.nodeValue + '</div></div>';
		}
		else
		{
			this.menu.innerHTML = ajax.responseXML.getElementsByTagName('reportbit')[0].firstChild.nodeValue;

			var inputs = fetch_tags(this.menu, 'input');
			for (var i = 0; i < inputs.length; i++)
			{
				if (inputs[i].type == 'submit')
				{
					var sbutton = inputs[i];
					var button = document.createElement('input');
					button.type = 'button';
					button.className = sbutton.className;
					button.value = sbutton.value;
					YAHOO.util.Event.addListener(button, 'click', vB_ReportPopupMenu.prototype.submit_onclick, this, true);
					sbutton.parentNode.insertBefore(button, sbutton);
					sbutton.parentNode.removeChild(sbutton);
					button.name = sbutton.name;
					button.id = sbutton.name + '_' + this.postid
				}
			}
			
			var textarea = fetch_tags(this.menu, 'textarea');
			console.log(textarea[0].id);
			YAHOO.util.Event.addListener(button, 'click', vB_ReportPopupMenu.prototype.submit_onclick, this, true);		
			YAHOO.util.Event.addListener(textarea[0], 'keyup', vB_ReportPopupMenu.prototype.increasetextarea, textarea[0].id, true);
			
		}
		this.activate_menu();
		this.open_menu(ajax.argument.e);
	}
}

/**
* Handles click events on report submit button
*/

vB_ReportPopupMenu.prototype.submit_onclick = function (e)
{
	this.submit();
	YAHOO.util.Event.preventDefault(e);
	return false;
}

/**
*	Catches the keypress of the report controls to keep them from submitting to inlineMod
*/
vB_ReportPopupMenu.prototype.repinput_onkeypress = function (e)
{
	switch (e.keyCode)
	{
		case 13:
		{
			YAHOO.util.Event.stopEvent(e);
			this.submit_onclick(e);
			return false;
		}
		default:
		{
			return true;
		}
	}
}

/**
* Queries for proper response to report, response varies
*
*/

vB_ReportPopupMenu.prototype.load_menu = function(e)
{
	// IE loses the event in the argument call below so we send a copy
	var eventCopy = {};
	for (var i in e)
	{
		eventCopy[i] = e[i];
	}
	YAHOO.util.Connect.asyncRequest("POST", fetch_ajax_url("ajax.php?do=reportajax&p=" + this.postid), {
		success: this.handle_menu_load,
		failure: this.handle_ajax_error,
		timeout: vB_Default_Timeout,
		scope: this,
		argument: {e:eventCopy}
	}, SESSIONURL + "securitytoken=" + SECURITYTOKEN + "&p=" + this.postid + "&ajax=1");
}

/**
* Handles AJAX Errors
*
* @param	object	YUI AJAX
*/
vB_ReportPopupMenu.prototype.handle_ajax_error = function(ajax)
{
	//TODO: Something bad happened, try again
	vBulletin_AJAX_Error_Handler(ajax);
};

/**
* Submits report
*
*/
vB_ReportPopupMenu.prototype.submit = function()
{
    if (YAHOO.util.Connect.isCallInProgress(this.menu.ajaxreq))
	return;

	this.psuedoform = new vB_Hidden_Form('report.php');
	this.psuedoform.add_variable('ajax', 1);
	this.psuedoform.add_variables_from_object(this.menu);

	this.menu.ajaxreq = YAHOO.util.Connect.asyncRequest("POST", fetch_ajax_url("report.php?do=sendemail2"), {
		success: this.handle_submit,
		failure: this.handle_ajax_error,
		timeout: vB_Default_Timeout,
		scope: this
	}, SESSIONURL + "securitytoken=" + SECURITYTOKEN + "&" + this.psuedoform.build_query_string());
	
	this.menu.reportform = YAHOO.util.Dom.getElementsByClassName('reportform', 'div', this.menu);
	YAHOO.util.Dom.setStyle(this.menu.reportform, 'opacity', '.5');
	
	this.menu.reportprogress = YAHOO.util.Dom.getElementsByClassName('progress3', 'img', this.menu);
	YAHOO.util.Dom.setStyle(this.menu.reportprogress, 'display', 'block');
	
}

/**
* Increase Reason Textarea Automatically
*
*/
vB_ReportPopupMenu.prototype.increasetextarea = function(e, textareaid) {
    var ta = document.getElementById(textareaid);
    var maxrows = 30;
    var lh = ta.clientHeight / ta.rows;
    while (ta.scrollHeight > ta.clientHeight && !window.opera && ta.rows < maxrows) {
        ta.style.overflow = 'hidden';
        ta.rows += 1;
    }
    if (ta.scrollHeight > ta.clientHeight) ta.style.overflow = 'auto';
}
